<?php

namespace Txd\Tags\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphPivot;

/**
 * Class Tag
 *
 * @property int $id
 * @property string $name
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property HasMany $taggables
 */
class Taggable extends MorphPivot
{
    protected $table = 'taggables';

    public $incrementing = false;

    public $timestamps = false;

    protected $casts = [
        'tag_id' => 'int',
        'forced' => 'int',
    ];

    protected $model_rules = [
        'tag_id' => [
            'required',
            'integer',
            'max:1.844674407371E+19',
            'min:0',
        ],
        'taggable_type' => [
            'required',
            'max:255',
        ],
        'taggable_id' => [
            'required',
            'max:36',
        ],
        'value' => [
            'nullable',
            'max:255',
        ],
        'forced' => [
            'integer',
            'max:127',
            'min:-128',
        ],
    ];

    protected $fillable = [
        'value',
        'forced',
    ];
}
