<?php

namespace Txd\Tags\Classes;

use Exception;
use Txd\Tags\Traits\HasTags;

class TagValue
{
    public function __construct(public $tag, public ?string $value) {}

    public static function fromTag($tag, ?string $value = null): self
    {
        if (!is_a($tag, HasTags::getTagClassName())) {
            throw new Exception('You cannot initialize a TagValue from a non Tag class');
        }

        return new self($tag, $value);
    }

    public static function fromString(string $string): self
    {
        [$name, $value] = explode(':', $string, 2);
        $tag = HasTags::getTagClassName()::firstOrCreate(['name' => trim($name)]);

        return new self($tag, trim($value));
    }
}
