
<?php

use Illuminate\Database\Eloquent\Model;
use Txd\Tags\Classes\TagValue;
use Txd\Tags\Traits\HasTags;

if (!function_exists('getAvailableTags')) {
    function getAvailableTags(?Model $taggableModel = null)
    {
        $tagClass = HasTags::getTagClassName();

        return $tagClass::when(
            $taggableModel,
            fn ($query) => $query->whereHas('taggables', fn ($q) => $q->where('taggable_type', $taggableModel::class)),
            fn ($query) => $query->with('taggables')
        )
            ->get()
            ->flatMap(fn ($tag) => $tag->taggables->pluck('value')->map(fn ($t) => trim($t))->filter()->unique()->map(fn ($v) => new TagValue($tag, $v)));
    }
}
