<?php

namespace Txd\Translations\Console;

use Illuminate\Console\Command;

class RenewTranslationsCacheCommand extends Command
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $name = 'translations:cache';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'renew translation cache token';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->outputComponents()->info('Renewing translations cache token');
        $token = \Illuminate\Support\Str::random(30);
        settings()->set('ltm_translations_version', $token, 'default', true);

        return $token;
    }
}
