<?php

namespace Txd\Translations;

class Translator extends \Barryvdh\TranslationManager\Translator
{
    protected $manager;

    protected function notifyMissingKey($key)
    {
        if (\Illuminate\Support\Str::startsWith($key, 'validation.values.')) {
            return;
        }
        [$namespace, $group, $item] = $this->parseKey($key);
        if ($this->manager && $namespace === '*' && $group) {
            if (empty($item)) {
                $item = $group;
                $group = '_json';
            }

            $this->manager->missingKey($namespace, $group, $item);
        }
    }
}
