<?php

namespace Txd\Translations\Console;

use Illuminate\Console\Command;
use Txd\Translations\Actions\RenewTranslationsCache;

class RenewTranslationsCacheCommand extends Command
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $name = 'translations:cache';

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'translations:cache {--force}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'renew translation cache token';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $force = $this->option('force');

        if (app()->isDownForMaintenance() && !$force) {
            $this->outputComponents()->warn('Application is down-for-maintainance and not force argument used, skipping...');

            return;
        }

        $this->outputComponents()->info('Renewing translations cache token');
        $token = app(RenewTranslationsCache::class)->handle();

        return $token;
    }
}
