<?php

namespace Txd\Translations\Exports;

use Illuminate\Database\Query\JoinClause;
use Illuminate\Translation\FileLoader;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class LocaleExport implements FromCollection, WithHeadings
{
    use Exportable;

    public function __construct(private string $lang) {}

    public function headings(): array
    {
        return ['Group', 'Key', 'Default Value', 'Target Value'];
    }

    public static function flattenArray(array $array, string $prefix = ''): array
    {
        $result = [];

        foreach ($array as $key => $value) {
            $currentKey = $prefix === '' ? $key : $prefix.'.'.$key;

            if (is_array($value)) {
                // Recursive call for nested arrays
                $result = array_merge($result, static::flattenArray($value, $currentKey));
            } else {
                $result[$currentKey] = $value;
            }
        }

        return $result;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        $default = \DB::table('ltm_translations')->where('locale', config('app.fallback_locale'))->select('id', 'group', 'key', 'value');

        $target = \DB::table('ltm_translations')->where('locale', $this->lang)->select('group', 'key', 'value');

        /** @var \Illuminate\Filesystem\Filesystem */
        $files = app('files');
        $path = app('path.lang');
        $loader = new FileLoader($files, $path);

        $out = [];
        $out['_json'] = $loader->load('default', '*', '*');
        foreach ($files->files($path.'/default') as $file) {
            $out[$file->getFilenameWithoutExtension()] = static::flattenArray($loader->load('default', $file->getFilenameWithoutExtension(), '*'));

        }

        $data = $default->leftJoinSub($target, 'target', function (JoinClause $join) {
            $join->on('ltm_translations.group', '=', 'target.group')->on('ltm_translations.key', '=', 'target.key');
        })->select('ltm_translations.group', 'ltm_translations.key', 'ltm_translations.value as default_value', 'target.value as target_value')->orderBy('ltm_translations.group')->orderBy('ltm_translations.key')->get();
        foreach ($out as $group => $keys) {
            foreach ($keys as $key => $value) {
                $present = $data->first(fn ($el) => $el->group === $group && $el->key === $key);
                if ($present) {
                    if (empty($present->default_value)) {
                        $present->default_value = $value;
                    }
                } else {
                    $data->push((object) [
                        'group' => $group,
                        'key' => $key,
                        'default_value' => $value,
                        'target_value' => null,
                    ]);
                }
            }
        }

        return $data->sortBy('key')->sortBy('group');
    }
}
