<?php

namespace Txd\Translations\Imports;

use App\Layout\FlashMessage;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\SkipsEmptyRows;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Txd\Translations\Actions\RenewTranslationsCache;

class LocaleImport implements SkipsEmptyRows, ToCollection, WithHeadingRow
{
    public function __construct(private string $lang, private bool $skip_empty = false, private bool $only_insert = false) {}

    public function collection(Collection $collection)
    {
        $current = DB::table('ltm_translations')->where('locale', $this->lang)->select('group', 'key', 'value')->get()->groupBy('group')->map(fn ($el) => $el->groupBy('key'));

        $unchanged = collect();
        $toChange = collect();
        $toAdd = collect();
        foreach ($collection as $translation) {

            $existing = $current[$translation['group']][$translation['key']][0] ?? null;
            if ($existing) {
                $tValue = $translation['target_value'];
                if (empty($tValue)) {
                    $tValue = null;
                }

                if ($existing->value !== $tValue && !($this->skip_empty && empty($tValue))) {
                    $toChange->add($translation);
                } else {
                    $unchanged->add($translation);
                }
            } else {
                $toAdd->add($translation);
            }
        }

        DB::beginTransaction();

        if (!$this->only_insert) {
            foreach ($toChange as $translation) {
                DB::table('ltm_translations')->where('locale', $this->lang)->where('group', $translation['group'])->where('key', $translation['key'])->update(['value' => $translation['target_value']]);
            }
        }
        foreach ($toAdd as $translation) {
            DB::table('ltm_translations')->insert(['locale' => $this->lang, 'group' => $translation['group'], 'key' => $translation['key'] ?? '', 'value' => $translation['target_value']]);
        }

        FlashMessage::add(trans('translations.added', ['n' => $toAdd->count()]));
        if (!$this->only_insert) {
            FlashMessage::add(trans('translations.changed', ['n' => $toChange->count()]));
            FlashMessage::add(trans('translations.unchanged', ['n' => $unchanged->count()]), 'info');
        } else {
            FlashMessage::add(trans('translations.unchanged', ['n' => $unchanged->count() + $toChange->count()]), 'info');
        }
        DB::commit();

        if ($toAdd->count() > 0 || (($toChange->count() > 0) && !$this->only_insert)) {
            app(RenewTranslationsCache::class)->handle();
        }

    }
}
