<?php

namespace Txd\WatchmanHook\Provider;

use Event;
use Illuminate\Console\Events\CommandFinished;
use Illuminate\Support\ServiceProvider;
use Txd\WatchmanHook\Listeners\LogScheduledCommandFinished;

/**
 *  *
 * @author Fabio Spadea <fabio@techseed.it>
 */
class TxdWatchmanHookServiceProvider extends ServiceProvider
{

    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {
        if (false !== strpos($this->app->version(), 'Lumen')) {
            if(method_exists($this->app, "configure")){
                $this->app->{"configure"}('txd_watchman_hook');
            }
        } else {
            // Publish config files
            $this->publishes([
                __DIR__ . '/../../config/txd_watchman_hook.php' => config_path('txd_watchman_hook.php'),
            ], 'config');
        }

        $this->mergeConfigFrom(
			__DIR__.'/../../config/txd_watchman_hook.php', 'txd_watchman_hook'
        );

        Event::listen(
            CommandFinished::class,
            LogScheduledCommandFinished::class
        );

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        //
    }

}
