<?php

if(!function_exists("debug_query_from_scratch")){

    /**
     * sostituisce i bindings a una query SQL
     * ATTENZIONE: questa funzione e' definita uguale anche nel pacchetto jsm/base, viene riportata anche qui per i sistemi che non sono aggiornati su jsm/base ma necessitano di tale funzionalita'
     *
     * @param string $sql
     * @param array $dati
     * @return string
     */
	function debug_query_from_scratch($sql, $dati){

		if(isset($dati) && $dati !== null && count($dati) > 0){

			if(strpos($sql, "?") !== false){

				//sostituiamo i ? in ordine
				foreach($dati as $value){
					$sql = preg_replace("/\?/", "'".$value."'", $sql, 1);
				}
			}else{
				foreach($dati as $key => $value){
					$sql = str_replace(":".$key, "'".$value."'", $sql);
				}
			}
		}

		return $sql;
	}
}

if(!function_exists("inspect_query_stack")){

	/**
	 * ritorna una collection con tutte le query eseguite da quando e' stato attivato il query logger, raggruppate per query, ordinate per tempo (globale) di esecuzione
	 * 
	 * per funzionare deve essere abilitato il queryLogger, o attivando il middleware automatico, altrimenti usando \DB::connection()->enableQueryLog(); prima dell'esecuzione delle query da ispezionare
     * 
     * ATTENZIONE: questa funzione e' definita uguale anche nel pacchetto jsm/base, viene riportata anche qui per i sistemi che non sono aggiornati su jsm/base ma necessitano di tale funzionalita'
	 *
	 * @return \Illuminate\Support\Collection
	 */
	function inspect_query_stack(): \Illuminate\Support\Collection {
		return collect(\DB::getQueryLog())->groupBy("query")->map(function($el){
			$n = $el->count();
			$time = $el->sum("time");
			return [
				"n" => $n,
				"time"=>$time,
				"avg"=>$time/$n,
				"queries" => $el->map(function($subEl){ return debug_query_from_scratch($subEl["query"], $subEl["bindings"]); })
			];
		})->sortByDesc("time");
	}
}