<?php

namespace Txd\WatchmanHook\Listeners;

use Carbon\Carbon;
use Cron\CronExpression;
use GuzzleHttp\Client;
use Illuminate\Console\Events\CommandFinished;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class LogScheduledCommandFinished
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param CommandFinished $event
     * @return void
     */
    public function handle($event)
    {
        if(config("txd_watchman_hook.enabled", false) && ($event->command ?? false) && !in_array($event->command, config("txd_watchman_hook.excluded_commands", []), true)){
            // xdebug_break();
            
            $info_watchman = [];
            $re = '/[^a-z0-9 .\-_]/i';
            $event_command = str_replace(":", ".", $event->command);
            $event_command = preg_replace($re, "-", $event_command);
    
            $info_watchman["hostname"] = str_slug(config("app.name"));
            $info_watchman["service"] = $event_command;
    
            app()->make(\Illuminate\Contracts\Console\Kernel::class);
            $schedule = app()->make(Schedule::class);
    
            /** @var \Illuminate\Console\Scheduling\Event $evento_scheduler */
            $evento_scheduler = collect($schedule->events())
                ->filter(function($el) use ($event) {
                    return strpos($el->command, $event->command) !== false;
                })
                ->first();
    
            // $info_watchman["evento"] = $evento_scheduler;
    
            if(is_null($evento_scheduler)){ //vuol dire che e' un comando non presente nello scheduler, quindi non lo tracciamo
                return;
            }
            
            $last_run = CronExpression::factory($evento_scheduler->expression)->getPreviousRunDate(CronExpression::factory($evento_scheduler->expression)->getPreviousRunDate());
            $next_run = CronExpression::factory($evento_scheduler->expression)->getNextRunDate(CronExpression::factory($evento_scheduler->expression)->getPreviousRunDate());
     
            $interval = (new Carbon($last_run))->diffInMinutes($next_run);

            $info_watchman["interval"] = $interval;
            
            /**
             * effettuiamo la chiamata per registrare host/servizio e ottenere il token per Nagios
             */

            $cache_id = "txd_watchman_hook.".$info_watchman["hostname"].".".$info_watchman["service"];
            $token_nagios = cache($cache_id, function() use ($cache_id, $info_watchman) {

                $jwt_secret = config("txd_watchman_hook.sign_secret");
                if(strlen($jwt_secret) < 10){
                    throw new \Exception(__METHOD__." | jwt secret must be at least 10 chars");
                }
    
                $payload = array(
                    "iss" => "txd_watchman_hook",
                    "iat" => time(),
                    "nbf" => time(),
                    "exp" => time() + 300,
                    "info" => $info_watchman,
                );
    
                /**
                 * IMPORTANT:
                 * You must specify supported algorithms for your application. See
                 * https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40
                 * for a list of spec-compliant algorithms.
                 */
                $jwt = \Firebase\JWT\JWT::encode($payload, $jwt_secret);
    
                $token_nagios = null;

                $client = new Client(['http_errors' => false]);
                $response = $client->get(config("txd_watchman_hook.watchman_url"), [
                    'headers' => [ 'Authorization' => 'Bearer ' . $jwt ]
                ]);

                $out = json_decode((string) $response->getBody(), true);

                $esito_chiamata = $response->getStatusCode() == 200 && ($out["stato"] ?? "KO") == "OK";

                if($esito_chiamata){
                    $token_nagios = $out["token"] ?? null;
                }else{
                    \Log::warning(__METHOD__." | errore chiamata watchman", ["risposta" => $out, "status_code" => $response->getStatusCode()]);
                }

                if(config("app.debug")){
                    cache([$cache_id => $token_nagios], now()->addMinutes(2));
                }else{
                    cache([$cache_id => $token_nagios], now()->addDays(30));
                }

                return $token_nagios;
            });
            

            if(strlen($token_nagios) == 0){ //vuol dire che qualcosa e' andato storto e non abbiamo il token per Nagios
                return;
            }

            /**
             * aggiungiamo (e togliamo) le info relative solo a nagios
             */

            unset($info_watchman["interval"]);

            $info_watchman["stato"] = ($event->exitCode === 0 ? "0" : "2");
            $info_watchman["testo"] = ($event->exitCode === 0 ? "OK" : "KO");
            $info_watchman["token"] = $token_nagios;
    
            $info_guzzle = collect($info_watchman)->map(function($el, $key){ return ["name" => $key, "contents" => $el]; })->values()->toArray();
            // jddd($info_guzzle, $evento_scheduler, $last_run, $next_run);
    
            $client = new Client();
            $client->post(config("txd_watchman_hook.nagios_url"), [
                'multipart' => $info_guzzle
            ]);
        }
    }
}
