<?php

if(!function_exists("txd_str_slug")){

    /**
     * Generate a URL friendly "slug" from a given string.
     * Wrapper per funzionare anche nel momento in cui tolgono l'helper
     *
     * @param  string  $title
     * @param  string  $separator
     * @param  string|null  $language
     * @return string
     */
	function txd_str_slug($title, $separator = '-', $language = 'en'){

		if(function_exists("str_slug")){
            return str_slug($title, $separator, $language);

        }elseif(class_exists("Illuminate\Support\Str") && method_exists("Illuminate\Support\Str", "Slug")){

            return Illuminate\Support\Str::slug($title, $separator, $language);

        }else{

            //in questo caso facciamo una cosa simile a mano (anche se non e' proprio uguale ma per i nostri fini va bene)
            $re = '/[^a-z0-9]/i';
            return mb_strtolower(preg_replace($re, $separator, $title));
        }
	}
}
