<?php

namespace Txd\WatchmanHook\Commands;

use Illuminate\Cache\FileStore;
use Illuminate\Console\Command;
use Illuminate\Console\Scheduling\CacheEventMutex;
use Illuminate\Console\Scheduling\Schedule;

class ScheduledCommandIsRunning extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'scheduledCommand:isRunning {command_signature}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = "Verifica se e' presente il mutex name del comando passato come parametro nella cache dell'applicativo (e quindi se per lo scheduler e' in esecuzione indipendentemente dai processi che girano)";

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $command_signature = $this->argument("command_signature");
        $this->line("Checking command: ".$command_signature);

        app()->make(\Illuminate\Contracts\Console\Kernel::class);
        $schedule = app()->make(Schedule::class);
        $cache_event = app()->make(CacheEventMutex::class);

        /** @var \Illuminate\Console\Scheduling\Event $evento_scheduler */
        $evento_scheduler = collect($schedule->events())
            ->filter(function($el) use ($command_signature) {
                return strpos($el->command, $command_signature) !== false;
            })
            ->first();

        if(is_null($evento_scheduler)){
            $this->error("Comando non trovato: ".$command_signature);
            return 1;
        }

        /** @var FileStore $cache */
        $cache = $cache_event->cache;
        $parts = array_slice(str_split($hash = sha1($evento_scheduler->mutexName()), 2), 0, 2);

        dump([
            "isPretendingRunning" => $cache_event->exists($evento_scheduler),
            "mutexName" => $evento_scheduler->mutexName(), 
            "cacheFileName" => $cache->getDirectory().'/'.implode('/', $parts).'/'.$hash,
        ]);
    }
}
