<?php

namespace Txd\WatchmanHook\Commands;

use Illuminate\Cache\FileStore;
use Illuminate\Console\Command;
use Illuminate\Console\Scheduling\CacheEventMutex;
use Illuminate\Console\Scheduling\Schedule;

use Symfony\Component\Process\Exception\ProcessFailedException;
use Symfony\Component\Process\Process;
use Txd\WatchmanHook\WatchmanHookHelpers;

class SupervisorRegisterCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'watchman-hook:register-supervisor';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = "Registra i processi controllati da supervisor come servizi su Nagios (va eseguito con un utente che possa operare `supervisorctl status`)";

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $command = "supervisorctl";
        $par = "status";

        //comando da usare in locale per simulare la chiamata
        // $command = "cat";
        // $par = base_path("test_supervisor.out");

        $process = new Process([$command, $par]);
		$process->run();

        if (!$process->isSuccessful()) {
			throw new ProcessFailedException($process);
		}

        $out = $process->getOutput();
        $out = str_replace("\n\r", "\n", $out);
        $out = str_replace("\r\n", "\n", $out);
        $out = str_replace("\r", "\n", $out);

        $lines = explode("\n", $out);

        // xdebug_break();

        foreach($lines as $line){
            $worker_command = trim(explode(":", $line)[0] ?? "");
            if(strlen($worker_command) == 0){
                continue;
            }

            $this->info("registering: ".$worker_command);

            $info_watchman = [];
            $info_watchman["hostname"] = config("txd_watchman_hook.nagios_hostname") ?? txd_str_slug(gethostname());
            $info_watchman["service"] = $worker_command;
            $info_watchman["service_type"] = "supervisor";

            $cache_id = "txd_watchman_hook.".$info_watchman["hostname"].".".$info_watchman["service"];
            WatchmanHookHelpers::watchmanRegistration($cache_id, $info_watchman);

        }

        $this->line("\nFine");
        
    }
}
