<?php

namespace Txd\WatchmanHook\Listeners;

use Carbon\Carbon;
use Cron\CronExpression;
use GuzzleHttp\Client;
use Illuminate\Console\Events\CommandFinished;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Txd\WatchmanHook\WatchmanHookHelpers;

class LogScheduledCommandFinished
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param CommandFinished $event
     * @return void
     */
    public function handle($event)
    {
        if(config("txd_watchman_hook.enabled", false) && ($event->command ?? false) && !in_array($event->command, config("txd_watchman_hook.excluded_commands", []), true)){
            // xdebug_break();

            $info_watchman = [];
            $re = '/[^a-z0-9 .\-_]/i';
            $event_command = str_replace(":", ".", $event->command);
            $event_command = preg_replace($re, "-", $event_command);

            $info_watchman["hostname"] = config("txd_watchman_hook.nagios_hostname") ?? txd_str_slug(gethostname());
            $info_watchman["service"] = txd_str_slug(basename(base_path()))."--".$event_command;
            $info_watchman["service_type"] = "scheduled_command";

            app()->make(\Illuminate\Contracts\Console\Kernel::class);
            $schedule = app()->make(Schedule::class);

            /** @var \Illuminate\Console\Scheduling\Event $evento_scheduler */
            $evento_scheduler = collect($schedule->events())
                ->filter(function($el) use ($event) {
                    //facciamo un controllo piu' preciso rispetto alla prima versione in cui c'erano casi di comandi ambigui
                    $comando_estrapolato = explode(" ", $el->command)[2] ?? null;
                    return $comando_estrapolato === $event->command;
                    // return strpos("'artisan' ".$el->command, $event->command) !== false;
                })
                ->first();

            // $info_watchman["evento"] = $evento_scheduler;

            if(is_null($evento_scheduler)){ //vuol dire che e' un comando non presente nello scheduler, quindi non lo tracciamo
                return;
            }

            $last_run = CronExpression::factory($evento_scheduler->expression)->getPreviousRunDate(CronExpression::factory($evento_scheduler->expression)->getPreviousRunDate());
            $next_run = CronExpression::factory($evento_scheduler->expression)->getNextRunDate(CronExpression::factory($evento_scheduler->expression)->getPreviousRunDate());

            $interval = (new Carbon($last_run))->diffInMinutes($next_run);

            $info_watchman["interval"] = $interval;

            /**
             * effettuiamo la chiamata per registrare host/servizio e ottenere il token per Nagios
             */

            $cache_id = "txd_watchman_hook.".$info_watchman["hostname"].".".$info_watchman["service"];
            $token_nagios = WatchmanHookHelpers::watchmanRegistration($cache_id, $info_watchman);

            if(strlen($token_nagios) == 0){ //vuol dire che qualcosa e' andato storto e non abbiamo il token per Nagios
                return;
            }

            /**
             * aggiungiamo (e togliamo) le info relative solo a nagios
             */

            unset($info_watchman["interval"]);
            unset($info_watchman["service_type"]);

            $info_watchman["stato"] = ($event->exitCode === 0 ? "0" : "2");
            $info_watchman["testo"] = ($event->exitCode === 0 ? "OK" : "KO");
            $info_watchman["token"] = $token_nagios;

            WatchmanHookHelpers::makeNagiosCall($info_watchman);
        }
    }
}
