<?php

namespace Txd\WatchmanHook;

use GuzzleHttp\Client;

class WatchmanHookHelpers {

    public static function watchmanRegistration($cache_id, array $info_watchman): ?string {
        
        return cache($cache_id, function() use ($cache_id, $info_watchman) {

            $jwt_secret = config("txd_watchman_hook.sign_secret");
            if(strlen($jwt_secret) < 10){
                throw new \Exception(__METHOD__." | jwt secret must be at least 10 chars");
            }

            $payload = array(
                "iss" => "txd_watchman_hook",
                "iat" => time(),
                "nbf" => time(),
                "exp" => time() + 300,
                "info" => $info_watchman,
            );

            /**
             * IMPORTANT:
             * You must specify supported algorithms for your application. See
             * https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40
             * for a list of spec-compliant algorithms.
             */
            $jwt = \Firebase\JWT\JWT::encode($payload, $jwt_secret, "HS256");

            $token_nagios = null;

            $client = new Client(['http_errors' => false]);
            $response = $client->get(config("txd_watchman_hook.watchman_url"), [
                'headers' => [ 'Authorization' => 'Bearer ' . $jwt ]
            ]);

            $out = json_decode((string) $response->getBody(), true);

            $esito_chiamata = $response->getStatusCode() == 200 && ($out["stato"] ?? "KO") == "OK";

            if($esito_chiamata){
                $token_nagios = $out["token"] ?? null;
            }else{
                \Log::warning(__METHOD__." | errore chiamata watchman", ["risposta" => $out, "status_code" => $response->getStatusCode()]);
            }

            if(config("app.debug")){
                cache([$cache_id => $token_nagios], now()->addMinutes(2));
            }else{
                cache([$cache_id => $token_nagios], now()->addDays(30));
            }

            return $token_nagios;
        });
    }


    public static function makeNagiosCall(array $info_watchman){

        $info_guzzle = collect($info_watchman)->map(function($el, $key){ return ["name" => $key, "contents" => $el]; })->values()->toArray();
        // jddd($info_guzzle, $evento_scheduler, $last_run, $next_run);

        $client = new Client();
        $client->post(config("txd_watchman_hook.nagios_url"), [
            'multipart' => $info_guzzle
        ]);
    }

}